<?php
    /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license https://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo https://www.geecom.org/?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../../../stripe/init.php";
    include "../../../include/costanti.php";
    include "../../../gUtil/DbManager.php";
    include "../../../classi/ecommerce/ConnettorePaypal.php";

    session_start();

    //i dati del database sono definiti nel file costanti.php
    $geecomDb = new DbManager($costantiDatabase);
    
    $impostazioniPagamenti = $geecomDb->leggiSingolaRiga("geecEc_impostazioniPagamenti",1);
    $idOrdine = filter_input(INPUT_GET,"id",FILTER_SANITIZE_ADD_SLASHES);
 
    $sandbox = ($impostazioniPagamenti["sandboxPaypal"]=="si") ? true : false;
    
    $connettore = new ConnettorePayPal($impostazioniPagamenti["clientIdPaypal"],$impostazioniPagamenti["secretPaypal"],$sandbox);
    $connettore->richiediAccessToken();
    $nomeCartaCredito  = $impostazioniPagamenti["nomeEstrattoConto"];
    
    print_r($connettore->recuperaRisultato3DS($idOrdine));
